/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.build.IProblem;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;

public class ProblemAnnotation
extends Annotation
implements IAnnotationPresentation,
IQuickFixableAnnotation {
    private static final String ERROR_ANNOTATION_TYPE = "com.aptana.editor.common.error";
    private static final String WARNING_ANNOTATION_TYPE = "com.aptana.editor.common.warning";
    private static final String INFO_ANNOTATION_TYPE = "com.aptana.editor.common.info";
    private static final String TASK_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.task";
    private static final int TASK_LAYER;
    private static final int INFO_LAYER;
    private static final int WARNING_LAYER;
    private static final int ERROR_LAYER;
    private static Image fgTaskImage;
    private static Image fgInfoImage;
    private static Image fgWarningImage;
    private static Image fgErrorImage;
    private static boolean fgImagesInitialized;
    private IProblem fProblem;
    private Image fImage;
    private boolean fImageInitialized = false;
    private int fLayer = 0;
    private boolean fIsQuickFixable;
    private boolean fIsQuickFixableStateSet = false;
    private String markerId;

    static {
        AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
        TASK_LAYER = ProblemAnnotation.computeLayer(TASK_ANNOTATION_TYPE, lookup);
        INFO_LAYER = ProblemAnnotation.computeLayer(INFO_ANNOTATION_TYPE, lookup);
        WARNING_LAYER = ProblemAnnotation.computeLayer(WARNING_ANNOTATION_TYPE, lookup);
        ERROR_LAYER = ProblemAnnotation.computeLayer(ERROR_ANNOTATION_TYPE, lookup);
        fgImagesInitialized = false;
    }

    private static int computeLayer(String annotationType, AnnotationPreferenceLookup lookup) {
        Annotation annotation = new Annotation(annotationType, false, null);
        AnnotationPreference preference = lookup.getAnnotationPreference(annotation);
        if (preference != null) {
            return preference.getPresentationLayer() + 1;
        }
        return 1;
    }

    public ProblemAnnotation(String markerId, IProblem problem) {
        this.markerId = markerId;
        this.fProblem = problem;
        if (this.fProblem.isTask()) {
            this.setType(TASK_ANNOTATION_TYPE);
            this.fLayer = TASK_LAYER;
        } else if (this.fProblem.isWarning()) {
            this.setType(WARNING_ANNOTATION_TYPE);
            this.fLayer = WARNING_LAYER;
        } else if (this.fProblem.isError()) {
            this.setType(ERROR_ANNOTATION_TYPE);
            this.fLayer = ERROR_LAYER;
        } else {
            this.setType(INFO_ANNOTATION_TYPE);
            this.fLayer = INFO_LAYER;
        }
    }

    public int getLayer() {
        return this.fLayer;
    }

    private void initializeImage() {
        if (!this.fImageInitialized) {
            this.initializeImages();
            String type = this.getType();
            if (TASK_ANNOTATION_TYPE.equals(type)) {
                this.fImage = fgTaskImage;
            } else if (INFO_ANNOTATION_TYPE.equals(type)) {
                this.fImage = fgInfoImage;
            } else if (WARNING_ANNOTATION_TYPE.equals(type)) {
                this.fImage = fgWarningImage;
            } else if (ERROR_ANNOTATION_TYPE.equals(type)) {
                this.fImage = fgErrorImage;
            }
            this.fImageInitialized = true;
        }
    }

    private void initializeImages() {
        if (fgImagesInitialized) {
            return;
        }
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        fgTaskImage = sharedImages.getImage("IMG_OBJS_TASK_TSK");
        fgInfoImage = sharedImages.getImage("IMG_OBJS_INFO_TSK");
        fgWarningImage = sharedImages.getImage("IMG_OBJS_WARN_TSK");
        fgErrorImage = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
        fgImagesInitialized = true;
    }

    public void paint(GC gc, Canvas canvas, Rectangle r) {
        this.initializeImage();
        if (this.fImage != null) {
            ImageUtilities.drawImage((Image)this.fImage, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
        }
    }

    public String getText() {
        return this.fProblem.getMessage();
    }

    public IProblem getProblem() {
        return this.fProblem;
    }

    public void setQuickFixable(boolean state) {
        this.fIsQuickFixable = state;
        this.fIsQuickFixableStateSet = true;
    }

    public boolean isQuickFixableStateSet() {
        return this.fIsQuickFixableStateSet;
    }

    public boolean isQuickFixable() {
        Assert.isTrue((boolean)this.isQuickFixableStateSet());
        return this.fIsQuickFixable;
    }

    public String getMarkerId() {
        return this.markerId;
    }
}

